class CORDEMIN 
--  debute, termine,
--  avance, recule,
--  fini, debut,
--  vide, 
--  insere_g,  -- insere a gauche du courant: l'elt insere -> courant
--  insere_d,  -- insere a droite du courant: idem
--  supprime_g,  -- supprime le courant; precedent -> courant
--  supprime_d,  -- supprime le courant; suivant -> courant

creation
  make

feature { NONE } -- attributs privs
  teteexp, queueexp: expanded PINCEMIN;

feature { ANY } -- attibuts publiques
  tete, queue: PINCEMIN; -- (version 0.76)
  courant: PINCEMIN;

feature -- mthodes publiques
  insere_g(x: PINCEMIN) is
  require courant /= tete
  do x.nouprec(courant.precedent); courant.nouprec(x); 
    x.nousuiv(courant); x.precedent.nousuiv(x); courant:= x end;

  insere_d(x: PINCEMIN) is
  require courant /= queue
  do x.nousuiv(courant.suivant); courant.nousuiv(x);
    x.nouprec(courant); x.suivant.nouprec(x); courant:= x end;

  supprime_g is
  require not vide; courant /= tete; courant/= queue
  local t: PINCEMIN
  do courant.precedent.nousuiv(courant.suivant);
    courant.suivant.nouprec(courant.precedent);
    t:= courant.precedent; courant:= Void; -- courant.forget; -- parce que n'pas de GC
	 	courant:= t end;

  supprime_d is
  require not vide; courant /= tete; courant/= queue
  local t: PINCEMIN
  do courant.precedent.nousuiv(courant.suivant);
    courant.suivant.nouprec(courant.precedent);
    t:= courant.suivant; courant:= Void; -- courant.forget; -- parce que n'pas de GC
	 	courant:= t end;

  debute is do sur_la_tete; avance end;

  termine is do sur_la_queue; recule end;

  avance is
  require not fini 
  do courant:= courant.suivant
  ensure courant = old courant.suivant
  end;

  recule is
  require not debut
  do courant:= courant.precedent
  ensure courant = old courant.precedent
  end;

  premier: BOOLEAN is do Result:= courant.precedent = tete end;
  
  dernier: BOOLEAN is do Result:= courant.suivant = queue end;
  
  fini: BOOLEAN is do Result:= courant = queue end;

  debut: BOOLEAN is do Result:= courant = tete end;

  vide: BOOLEAN is do Result:= tete.suivant = queue end; 

-- deux fonctions utilitaires
-- on ne veut pas faire de classe diffre :
-- principe d'extension versus spcialisation
-- feature { ON DEVRAIT METTRE ICI LES CLASSES UTILISATRICES DU PROJET }
feature { NONE }
  sur_la_tete is do courant:= tete end;

  sur_la_queue is do courant:= queue end;

feature
  make is
  do
    tete:= teteexp; queue:= queueexp;
    tete.nousuiv(queue);
	 queue.nouprec(tete);
	 sur_la_tete
  end;

end
