deferred class ELT_MESURE
--  saisis,
--  ok,
--  affiche,
--  efface,
--  nbr_de_temps, valeur_par_temps,
--  composee, ennaire,
--  fixe_msg_mesure,
--  numero, fixe_numero, numero_suivant,
inherit PINCEMIN; ES; VALEURS; EXCEPTIONS;

feature { ANY }
  ok: BOOLEAN;
  numero: INTEGER;
  nbr_de_temps, valeur_par_temps: INTEGER;
  format_num_tps: INTEGER; -- nbr de digit pour le format d'aff. du temps
  composee: BOOLEAN;
  ennaire: INTEGER;

feature
  fixe_numero(n: INTEGER) is do numero:= n end;
  
  fixe_format_num_tps(n: INTEGER) is do format_num_tps:= n end;

  numero_suivant:INTEGER is deferred end;


  saisis is deferred end;

  affiche is deferred end;

  efface is deferred end;

feature
  fixe_msg_mesure is
  do
    es.msg_mesure.head(0);
    inspect ennaire
      when 2 then
        es.msg_mesure.append("Mesure binaire  ")
      when 3 then
        if composee then es.msg_mesure.append("Mesure ternaire comp.  ")
        else es.msg_mesure.append("Mesure ternaire dcomp.  ") end
      when 5 then
        if composee then es.msg_mesure.append("Mesure quinternaire comp.  ")
        else es.msg_mesure.append("Mesure quinternaire dcomp.  ") end
      when 7 then
        if composee then es.msg_mesure.append("Mesure septernaire comp.  ")
        else es.msg_mesure.append("Mesure septernaire dcomp. a ") end
      else raise("Oh la, l c'est bogue !!");
    end;
    ajoute_msg_nbr_de_temps;
    ajoute_msg_valeur;
  end;

feature { NONE } -- methodes utilitaires
  ajoute_msg_nbr_de_temps is
  local s: STRING;
  do
    s:= nbr_de_temps.to_string;
    es.msg_mesure.append(s); format_num_tps:= s.count;
    es.msg_mesure.append(" temps");
  end;

  ajoute_msg_valeur is
  do
    es.msg_mesure.append("  la ");
    inspect valeur_par_temps
      when qad   then es.msg_mesure.append("quadruple crh (q)")
      when tpl   then es.msg_mesure.append("triple crh (t)")
      when tplp  then es.msg_mesure.append("triple crh pointe (t.)")
      when tplp_tpl then es.msg_mesure.append("(t. t ou qqqqq)")
      when dbl   then es.msg_mesure.append("double crh (f)")
      when dblp  then es.msg_mesure.append("double crh pointe (f.)")
      when dblp_dbl then es.msg_mesure.append("(f. f ou ttttt)")
      when dblpp then es.msg_mesure.append("double crh pointe 2 (f..)")
      when crh   then es.msg_mesure.append("croche ([)")
      when crhp  then es.msg_mesure.append("croche pointe ([.)")
      when crhp_crh then es.msg_mesure.append("([. [ ou fffff)")
      when crhpp then es.msg_mesure.append("croche pointe 2 ([..)")
      when nor   then es.msg_mesure.append("noire (!)")
      when norp  then es.msg_mesure.append("noire pointe (!.)")
      when norp_nor then es.msg_mesure.append("(!. ! ou [[[[[)")
      when norpp then es.msg_mesure.append("noire pointe 2 (!..)")
      when bch   then es.msg_mesure.append("blanche (d)")
      when bchp  then es.msg_mesure.append("blanche pointe (d.)")
      when bchp_bch then es.msg_mesure.append("(d. d ou !!!!!)")
      when bchpp then es.msg_mesure.append("blanche pointe 2 (d..)")
      when rnd   then es.msg_mesure.append("ronde (o)")
      when rndp  then es.msg_mesure.append("ronde pointe (o.)")
      when rndp_rnd then es.msg_mesure.append("(o. o ou ddddd)")
      when rndpp then es.msg_mesure.append("ronde pointe 2 (o..)")
      else raise("Valeur de temps inconnue");
    end

  end;

end -- class ELT_MESURE
