class PORTEE
--  saisis,
--  affiche,
--  tampon,
--  fenetre,
--  rafraichis_la_zone
inherit ES; VALEURS; CORDEMIN rename make as cordemin_make end;
	TAMPON_PORTEE rename make as tampon_portee_make end;
	
creation
	make

feature { NONE }
  cm: CHG_MESURE;
  m: MESURE;
feature { NONE }
  numero_debut_aff: INTEGER;
  nbr_mesure_cree: INTEGER;
  ok: BOOLEAN;
  fin_mesure: BOOLEAN;
  seuil_ligne: REAL is 0.63 -- pourcentage qui fixe longueur_ligne
  longueur_ligne: INTEGER; -- taille moy. d'une mesure ? (1 tps o. -> 96q)
  car_sauve: expanded CHARACTER; -- caractre remplace par '@'
  
  digit3: DIGIT3;
    
feature 
  saisis is
  local elt_m: ELT_MESURE;
  do
    from fin_mesure:= false; fixe_mesure_initiale
    until fin_mesure = true
    loop
      elt_m?= courant;

		-- on ne doit pas afficher de message "premier temps"
		--  partir d'une ancienne mesure (on est entre deux mesures)
      es.msg_temps.head(0);
      es.msg_temps.append(es.msg_mesure);
      es.msg_temps.append(" : ");
      es.msg_temps.append((1).to_string_format(elt_m.format_num_tps));
      es.msg_temps.append(" tps");
      es.aff_msg_mesure(es.msg_temps);
      es.rafraichis; -- repositionne le curseur dans la portee (plus sr)

		fen_num.set_curinvis;	
      affiche_numero(elt_m.numero_suivant);
		fen_num.unset_curinvis;	
      es.rafraichis; -- repositionne le curseur dans la portee

      es.lis_car;
      inspect es.car
      when 'C', '1'..'9' then
        es.remet_car;
        elt_m?= courant;
        !! cm.make;
        cm.fixe_numero(elt_m.numero_suivant);
        cm.saisis;
        if cm.ok then
          insere_d(cm);
			 es.eff_msg_mesure;
			 avance_aff_mesure;
        else cm.efface;
		  	    -- cm.forget -- parce que n'pas de GC
		  end
      when '|' then fin_mesure:= true
      when Ch_bs then -- Ch_del then
        es.pose_question(es.elt_mesure_eff);
        if es.reponse then
          recule_aff_mesure;
          elt_m?= courant;
          elt_m.efface;
			 if elt_m.numero = elt_m.numero_suivant -- est un chg de mesure ?
			 then es.eff_msg_mesure; 
          else nbr_mesure_cree:= nbr_mesure_cree-1
			 end
          supprime_g; -- fais le forget et precedent -> courant
		    fen_num.set_curinvis;	
          efface_numero;
		    fen_num.unset_curinvis;	
          if vide
          then
            fixe_mesure_initiale;
          else
            elt_m?= courant;
            elt_m.fixe_msg_mesure
          end
        end
      when '%/27/' then	-- commande (entrer un numero de mesure)
		  -- redirige temporairement (les critures et) la zone de saisie.
		  es.fixe_zone_courante(digit3);
		  digit3.affiche_msg_init;
        digit3.saisis;
		  es.fixe_zone_courante(Current);
        if digit3.ok then
          va_mesure(digit3.nombre)
        else
          es.fixe_zone_courante(digit3);
          digit3.efface;
          es.fixe_zone_courante(Current)
        end
      else
        es.remet_car;
        elt_m?= courant;
        !! m.make(elt_m.nbr_de_temps, elt_m.valeur_par_temps);
        m.fixe_numero(elt_m.numero_suivant);
		  m.fixe_format_num_tps(elt_m.format_num_tps);
        if elt_m.composee then m.fixe_composee end;
        m.fixe_ennaire(elt_m.ennaire);
        m.saisis;
        if m.ok then
          insere_d(m); nbr_mesure_cree:= nbr_mesure_cree+1
			 avance_aff_mesure;
        else m.efface;
             -- m.forget -- parce que n'pas de GC
        end
      end
    end;
    es.ecr_car('|');
  end;

feature { NONE }
  msg_init: STRING is "Entrer une mesure";
	 
  fixe_mesure_initiale is
  local fin: BOOLEAN;
  do
    from fin:= false; affiche_numero(1); nbr_mesure_cree:= 0
    until fin = true
    loop
      es.eff_msg_mesure; es.aff_msg_mesure(msg_init);
      es.rafraichis; -- repositionne le curseur dans la portee
      !! cm.make;
      cm.fixe_numero(1);
      cm.saisis;
      if cm.ok then
        insere_d(cm);
        fin:= true
      else cm.efface end
    end
  end;


feature { NONE }
  -- serait  mettre dans une classe de commandes de l'editeur de rythme
  -- avec son compre DIGIT3...
  va_mesure(num: INTEGER) is
  local anc_num_deb: INTEGER; fich_ecr: STD_FILE_WRITE; nom_fich: STRING;
  do
    avance_a_la_mesure_numero(num);
    if ( ok ) then
      anc_num_deb:= numero_debut_aff;

      fenetre.set_curinvis; fen_num.set_curinvis
      eff_portee;
      affiche(num);
      fenetre.unset_curinvis; fen_num.unset_curinvis

		-- redirige temporairement (les critures et) la zone de saisie.
      es.fixe_zone_courante(digit3);
      digit3.affiche_msg_fin;
      es.fixe_zone_courante(Current);	
		
      io.read_character; -- laisser cette ligne ici
	   if io.last_character = '$' then
        !! fich_ecr.make; !! nom_fich.make(0);
		  nom_fich.append("t");
		  nom_fich.append(num.to_string);
		  nom_fich.append(".txt");
		  -- A` faire :
		  -- i) tester que le fichier a t cr fich_ecr /= Void
		  -- cela est fait par une post-condition 'ensure' dans STD_FILE_WRITE
		  -- mais en mode -boost les test-conditionnels sont invalides par SmallE. 
		  -- ii) De plus, les critures dans les mmoires de masse requierts de tester
		  -- (logiciel) chaque accs pour une erreur de mcanique ou d'lectronique.
		  -- Les accs en mmoire centrale (rellement dans la mmoire physique, vive)
		  -- sont immdiats ou contr^ols, vrifis par la micro-lectronique
		  -- ou des protocoles de transferts labors en micro-code.
		  -- Bref, le logiciel ne devrait pas intervenir pour ceux-ci, sauf si,
		  -- la mmoire centrale est considre comme mmoire de masse ; ce qui
		  -- est souvent le cas en utilisant les redirections vers un disque virtuel. 
		  -- STD_FILE_WRITE hrite de OUTPUT_STREAM 
		  -- 'write_byte()' est implant par un 'external "SmallEiffel"' bon, mais
		  -- il n'y a pas de variable 'io_err'  tester aprs criture.
        fich_ecr.connect_to(nom_fich); 
        if depassement_droite then tampon.put(car_sauve, es.columns) end;
        fich_ecr.put_string(tampon);
        fich_ecr.put_character('|'); -- pour double barre de fin de portee
	     fich_ecr.disconnect;
		end;
			
      eff_portee;
      affiche(anc_num_deb);
    end;
  end;
 
  msg_creation: STRING is "Mesure non cre";
  
  avance_a_la_mesure_numero(num: INTEGER) is
  local elt_m: ELT_MESURE;
  do
    ok:= true
    if ( nbr_mesure_cree = 0 or num > nbr_mesure_cree ) then
      es.aff_msg(msg_creation)
      ok:= false;
    else
      from debute; elt_m?= courant
--	   invariant not elt_m.void -- normalement plus necessaire
--	   variant num - elt_m.numero -- irrealisable pour cause de mme numero
      until fini or elt_m.numero = num
      loop
        avance;
        elt_m?= courant
      end;
    end;
--  rescue
--    es.aff_msg(err_avance_mesure);
--    retry -- fixe un booleen avant (pas de reprise ici)
  end;

  depassement_droite: BOOLEAN is do Result:= tampon.count >= es.columns end;
  
  indique_depassement_droite is
  do
    -- '@' indicateur de surcharge de la ligne d'e'dition
    if depassement_droite then
      car_sauve:= tampon.item(es.columns); -- sauvegarde du caractre
      tampon.put('@', es.columns); -- remplace par '@'
      es.rafraichis
    end;
  end;

  
feature
  affiche(num: INTEGER) is
  local elt_m: ELT_MESURE;
  do
    tampon.head(0); tampon_num.head(0);
    if (num = 1) then tampon.append(clef);
    else tampon.append(clef_cti);
    end;
    tampon_num.append(clef_num);

    avance_a_la_mesure_numero(num);
    if ( ok ) then elt_m?= courant end; -- sas

    if not fini then
      from affiche_numero(elt_m.numero)
      until fini or 		depassement_droite				-- ici, plus
      loop
        elt_m?= courant;
        elt_m.affiche;
        affiche_numero(elt_m.numero_suivant);
        						indique_depassement_droite;	-- plus, l.
        avance
      end;
      if fin_mesure then es.ecr_car('|') end
    end;
	 
    if fini then recule end; -- sur le dernier (fini est vrai si sur la queue)
  end;


feature { NONE }
  eff_portee is
  do
    fenetre.erase;
    fenetre.display;
    fen_num.erase;
    fen_num.display;
  end;

  avance_aff_mesure is
  do
    if tampon.count > longueur_ligne
	 then
      fenetre.set_curinvis; fen_num.set_curinvis
		from
      until tampon.count <= longueur_ligne or
        nbr_mesure_cree <= numero_debut_aff
      loop
        eff_portee;
        numero_debut_aff:= numero_debut_aff+1;
        affiche(numero_debut_aff)
      end
      fenetre.unset_curinvis; fen_num.unset_curinvis
    end;
	 indique_depassement_droite	-- pour (nbr_mesure_cree <= numero_debut_aff)
  end;
 
  recule_aff_mesure is
  local elt_m: ELT_MESURE;
  do
    fenetre.set_curinvis; fen_num.set_curinvis
    from
    until numero_debut_aff = 1 or tampon.count >= longueur_ligne
    loop
      eff_portee;
      elt_m?= courant;
      numero_debut_aff:= numero_debut_aff-1;
      affiche(numero_debut_aff)
    end
    fenetre.unset_curinvis; fen_num.unset_curinvis
  end;

feature
  -- numero de la ligne ou doit appara^itre la portee
  make(num: INTEGER) is
  do
    cordemin_make;
	 
    numero_debut_aff:= 1;
    fin_mesure:= false; ok:= true;
    longueur_ligne:= (es.columns * seuil_ligne).ceiling; 
  
    tampon_portee_make(num);

    -- ne pas mettre expanded, laisser ici
	 !! digit3.make(es.fen_msg); -- ou plutt une fenetre de commande...
  end;

end -- class PORTEE
