class SYMBOLE_GROUPE
--  saisis,
--  ok,
--  nouveau
inherit EXCEPTIONS; ES; SEPARATEUR;

feature { ANY }
  nouveau: ELT_RYT;
  est_silence: BOOLEAN;	-- pour distinguer note et silence dans un groupe
  ok: BOOLEAN;

feature
  saisis is
  do
    ok:= true;
    es.lis_car;
    fixe_nouveau(es.car);
    if ok then 
      es.lis_car;
      inspect es.car 
        when '.' then
          es.ecr_car('.');
          es.lis_car;
          inspect es.car
            when '.' then es.ecr_car('.'); nouveau.pointe_dbl
            else nouveau.pointe; es.remet_car
          end
        else es.remet_car
      end
    end 
  end;   

feature { NONE }
  fixe_nouveau(c: CHARACTER) is
  local rd: RONDE; bc: BLANCHE; nr: NOIRE; cr: CROCHE; db: DOUBLEC;
        tp: TRIPLE; qa: QUADRUPLE;
        pa: PAUSE; dp: DEMI_PAUSE; sp: SOUPIR; ds: DEMI_SOUPIR;
        s4: SOUPIR4; s8: SOUPIR8; s16: SOUPIR16;
  do  
    est_silence:= false;
	 
    inspect c
    when 'o' then es.ecr_car('o'); !! rd.make; nouveau:= rd
    when 'd' then es.ecr_car('d'); !! bc.make; nouveau:= bc 
    when '!' then es.ecr_car('!'); !! nr.make; nouveau:= nr 
    when '[' then es.ecr_car('['); !! cr.make; nouveau:= cr 
    when 'f' then es.ecr_car('f'); !! db.make; nouveau:= db 
    when 't' then es.ecr_car('t'); !! tp.make; nouveau:= tp 
    when 'q' then es.ecr_car('q'); !! qa.make; nouveau:= qa
   
    when '-' then es.ecr_car('-'); !! pa.make; nouveau:= pa; est_silence:= true
    when '=' then es.ecr_car('='); !! dp.make; nouveau:= dp; est_silence:= true
    when '<' then es.ecr_car('<'); !! sp.make; nouveau:= sp; est_silence:= true
    when '>' then es.ecr_car('>'); !! ds.make; nouveau:= ds; est_silence:= true
    when 'k' then es.ecr_car('k'); !! s4.make; nouveau:= s4; est_silence:= true
    when 'x' then es.ecr_car('x'); !! s8.make; nouveau:= s8; est_silence:= true
    when 'w' then es.ecr_car('w'); !! s16.make; nouveau:= s16; est_silence:= true
   
    else ok:= false; es.aff_msg(es.symbole_groupe_inconnu); es.rafraichis
    end
  end;

end -- class SYMBOLE_GROUPE
