class TAMPON
--  lis_car, remet_car, car, vide,
--  ecr_car, eff_car, ecr_chn, eff_chn, ecr_digit,
--  aff_msg, aff_mesure,
--  rafraichis,
--  pose_question, reponse,
--  fixe_zone_courante,
inherit SCREENMAN; MESSAGES rename make as messages_make end;

creation
	make

feature { ANY }
  car: CHARACTER;
  lis_ancien: BOOLEAN;
  reponse: BOOLEAN;

feature { PORTEE } -- sinon cree une fenetre de commande pour DIGIT3
  fen_msg: WINDOW;
feature { NONE }
  fen_mesure: WINDOW; 
  zone_courante: ZONE_TAMPONNEE;

feature
  -- redirige temporairement (les critures et) la zone de saisie, 
  -- simule (ou mule) un deuxime bloc de saisie :
  --  la manire de tout diteur de texte pleine page
  -- diteur-interprteur en ligne et passage en mode commande plus, 
  -- plus, un deuxime diteur-interprteur en ligne de commande
  fixe_zone_courante(zone: ZONE_TAMPONNEE) is do zone_courante:= zone end;

  rafraichis is do zone_courante.rafraichis_la_zone end;

  vide is do lis_ancien:= false end;

  lis_car is 
  do
    if not lis_ancien then io.read_character; car:= io.last_character end;
    lis_ancien:= false
  end;

  remet_car is do lis_ancien:= true end;

  ecr_car(c: CHARACTER) is
  do
    zone_courante.tampon.extend(c);
    rafraichis
  end;

  ecr_digit(i: INTEGER) is
  do
    zone_courante.tampon.extend(i.digit);
    rafraichis
  end;

  ecr_chn(s: STRING) is
  do
    zone_courante.tampon.append(s);
    rafraichis
  end;

  eff_car is
  do
    zone_courante.tampon.head(zone_courante.tampon.count-1);
	 zone_courante.tampon.extend(' ');
    rafraichis;
    zone_courante.tampon.head(zone_courante.tampon.count-1);
    rafraichis;
  end;
 
  eff_chn(n: INTEGER) is
  local s: STRING;
  do
    zone_courante.tampon.head(zone_courante.tampon.count-n);
	 !! s.blank(n)
	 zone_courante.tampon.append(s);
    rafraichis;
    zone_courante.tampon.head(zone_courante.tampon.count-n);
    rafraichis;
  end;

  pose_question(msg: STRING) is
  local c: CHARACTER; msg_rep: STRING;
  do 
    reponse:= false; !! msg_rep.copy(msg);
    fen_msg.erase
    fen_msg.display;
    fen_msg.associate_text(msg);
    fen_msg.display;
    io.read_character; c:= io.last_character
    if c = 'o' or c = 'O'
	 then reponse:= true;
	 	msg_rep.remove_last(1); msg_rep.extend('O')	
    else
	 	msg_rep.remove_last(1); msg_rep.extend('N')	
	 end;
	 fen_msg.associate_text(msg_rep);
	 fen_msg.display
  end;

  aff_attn(msg: STRING) is
  do
    fen_mesure.set_curinvis;
    fen_msg.erase
    fen_msg.display
    fen_msg.associate_text(msg);
    fen_msg.display
    fen_mesure.unset_curinvis;
  end;
	
  aff_msg(msg: STRING) is
  do
    fen_msg.erase
    fen_msg.display;
    fen_msg.associate_text(msg);
    bell; -- attire l'attention de l'utilisateur
    fen_msg.display;
  end;

  eff_msg_mesure is
  do
    fen_mesure.set_curinvis;
    fen_mesure.erase;
    fen_mesure.display;
    fen_mesure.unset_curinvis;
  end;
  aff_msg_mesure(msg: STRING) is
  do
    fen_mesure.set_curinvis;
    fen_mesure.associate_text(msg);
    fen_mesure.display;
    fen_mesure.unset_curinvis;
  end;

  make is
  do
    set_device;
	 clear;
	 map_arrow_keys; -- la touche HELP fourni 0x9B(Amiga) '?' '~'
	 cursor_enable;
	 raw;
    messages_make;

    !! fen_msg.make(1, columns, lines-1, 0);
    !! fen_mesure.make(1, columns, 0, 0);

    fen_msg.set_reverse;
    fen_mesure.set_reverse;
				
    lis_ancien:= false
  end;
  
end
