class WINDOW

creation
	make

feature { ANY }
	yy, xx : INTEGER;
	largeur, hauteur: INTEGER;

feature { NONE }
	fenetre: POINTER;
	
feature
	display is do wrefresh(fenetre) end
   add_char(c: CHARACTER) is
   do
      waddch(fenetre, c)
   end;
   add_str(s: STRING) is
   do
      waddstr(fenetre, s.to_external)
   end;
	del_char is do wdelch(fenetre) end;
	associate_text(s: STRING) is -- bizarre coord relative
	do
		mvwaddstr(fenetre, 0, 0, s.to_external)
	end;
	set_reverse is do wattrset(fenetre, 262144) end; -- A_REVERSE (curses.h)
	set_curinvis is do leaveok(fenetre, 1) end;
	unset_curinvis is do leaveok(fenetre, 0) end;
		
	move_cursor(y: INTEGER; x: INTEGER) is do wmove(fenetre, y, x) end;
	erase is do werase(fenetre) end;

feature { NONE }
	waddch(fen: POINTER; c: CHARACTER) is external "C_WithoutCurrent" end;
	wdelch(fen: POINTER) is external "C_WithoutCurrent" end;
	mvwaddch(fen: POINTER; y: INTEGER; x: INTEGER; c: CHARACTER)
		is external "C_WithoutCurrent" end;
	waddstr(fen: POINTER; p: POINTER) is external "C_WithoutCurrent" end;
	mvwaddstr(fen: POINTER; y: INTEGER; x: INTEGER; p: POINTER)
		is external "C_WithoutCurrent" end;
	wrefresh(fen: POINTER) is external "C_WithoutCurrent" end;
	wattrset(fen: POINTER; attr: INTEGER) is external "C_WithoutCurrent" end;
	leaveok(fen: POINTER; b: INTEGER) is external "C_WithoutCurrent" end;
	wmove(fen: POINTER; y: INTEGER; x: INTEGER)
		is external "C_WithoutCurrent" end;
	newwin(l: INTEGER; c: INTEGER; begx: INTEGER; begy: INTEGER): POINTER
		is external "C_WithoutCurrent" end;
	werase(fen: POINTER) is external "C_WithoutCurrent" end;
						
feature
	make(h :INTEGER; l: INTEGER; y: INTEGER; x: INTEGER) is
	do
		yy:= y; xx:= x; hauteur:= h; largeur:= l;
		fenetre:= newwin(h, l, y, x);
	end
end
